/**
 * \file daemon_log.c
 *
 * \brief Daemon functions for logging
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#include <syslog.h>
#include "daemon_log.h"

void daemon_log(daemon_log_level_t level, const char *fmt, ...)
{
    va_list args = {0};

    va_start(args, fmt);

    daemon_vlog(level, fmt, args);

    va_end(args);
}

void daemon_vlog(daemon_log_level_t level, const char *fmt, va_list args)
{
    int priority;

    switch (level) {
    case DAEMON_LOG_DEBUG:
        priority = LOG_DEBUG;
        break;

    case DAEMON_LOG_INFO:
        priority = LOG_DAEMON | LOG_NOTICE;
        break;

    case DAEMON_LOG_WARNING:
        priority = LOG_DAEMON | LOG_WARNING;
        break;

    case DAEMON_LOG_IMPORTANT_INFO:
        priority = LOG_DAEMON | LOG_WARNING;
        break;

    default:
        syslog(LOG_DAEMON | LOG_NOTICE,
               "Unknown SDC Daemon msg priority level.");
    /* Fall through */
    case DAEMON_LOG_ERROR:
        priority = LOG_DAEMON | LOG_ERR;
        break;
    }

    vsyslog(priority, fmt, args);
}
